/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioMetaData;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.javasound.JSMinim;
import ddf.minim.spi.AudioRecording;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.share.sampled.AudioUtils;

class JSAudioRecording
implements AudioRecording,
Runnable {
    private AudioMetaData meta;
    private byte[] samples;
    private Thread iothread;
    private boolean play;
    private boolean loop;
    private int numLoops;
    private int loopBegin;
    private int loopEnd;
    private byte[] rawBytes;
    private int totalBytesRead;
    private boolean shouldRead;
    private int bytesWritten;
    protected AudioFormat format;
    private SourceDataLine line;
    private boolean finished;
    private JSMinim system;

    JSAudioRecording(JSMinim jSMinim, byte[] byArray, SourceDataLine sourceDataLine, AudioMetaData audioMetaData) {
        this.system = jSMinim;
        this.samples = byArray;
        this.meta = audioMetaData;
        this.format = sourceDataLine.getFormat();
        this.finished = false;
        this.line = sourceDataLine;
        this.loop = false;
        this.play = false;
        this.numLoops = 0;
        this.loopBegin = 0;
        this.loopEnd = (int)AudioUtils.millis2BytesFrameAligned(this.meta.length(), this.format);
        this.rawBytes = new byte[sourceDataLine.getBufferSize() / 8];
        this.iothread = null;
        this.totalBytesRead = 0;
        this.bytesWritten = 0;
        this.shouldRead = true;
    }

    @Override
    public void run() {
        while (!this.finished) {
            if (this.play) {
                if (this.shouldRead) {
                    if (this.loop) {
                        this.readBytesLoop();
                    } else {
                        this.readBytes();
                    }
                }
                this.writeBytes();
                Thread.yield();
                continue;
            }
            this.sleep(30000);
        }
        this.line.flush();
        this.line.close();
        this.line = null;
    }

    private void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void readBytes() {
        int n = this.samples.length - this.totalBytesRead;
        if (n < this.rawBytes.length) {
            this.readBytes(n, 0);
            this.system.debug("readBytes: filling rawBytes from " + n + " to " + this.rawBytes.length + " with silence.");
            int n2 = 0;
            if (this.format.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED) {
                n2 = -128;
            }
            for (int i = n; i < this.rawBytes.length; ++i) {
                this.rawBytes[i] = n2;
            }
            this.play = false;
        } else {
            this.readBytes(this.rawBytes.length, 0);
        }
    }

    private synchronized void readBytesLoop() {
        int n = this.loopEnd - this.totalBytesRead;
        if (n <= 0) {
            this.setMillisecondPosition(this.loopBegin);
            this.readBytesLoop();
            return;
        }
        if (n < this.rawBytes.length) {
            this.readBytes(n, 0);
            if (this.loop && this.numLoops == 0) {
                this.loop = false;
                this.play = false;
            } else if (this.loop) {
                this.setMillisecondPosition(this.loopBegin);
                this.readBytes(this.rawBytes.length - n, n);
                if (this.numLoops != -1) {
                    --this.numLoops;
                }
            }
        } else {
            this.readBytes(this.rawBytes.length, 0);
        }
    }

    private void readBytes(int n, int n2) {
        System.arraycopy(this.samples, this.totalBytesRead, this.rawBytes, n2, n);
        this.totalBytesRead += n;
    }

    private void writeBytes() {
        int n = this.rawBytes.length - this.bytesWritten;
        int n2 = this.line.write(this.rawBytes, this.bytesWritten, n);
        if (n2 != n) {
            this.shouldRead = false;
            this.bytesWritten += n2;
        } else {
            this.shouldRead = true;
            this.bytesWritten = 0;
        }
    }

    @Override
    public void play() {
        this.line.start();
        this.loop = false;
        this.numLoops = 0;
        this.play = true;
        this.iothread.interrupt();
    }

    @Override
    public boolean isPlaying() {
        return this.play;
    }

    @Override
    public void pause() {
        this.line.stop();
        this.play = false;
    }

    @Override
    public void loop(int n) {
        this.loop = true;
        this.numLoops = n;
        this.play = true;
        this.setMillisecondPosition(this.loopBegin);
        this.line.start();
        this.iothread.interrupt();
    }

    @Override
    public void open() {
        this.iothread = new Thread(this);
        this.finished = false;
        this.iothread.start();
    }

    @Override
    public void close() {
        this.line.stop();
        this.finished = true;
        try {
            this.iothread.join(10L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.iothread = null;
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public int getLoopCount() {
        return this.numLoops;
    }

    @Override
    public synchronized void setLoopPoints(int n, int n2) {
        this.loopBegin = n <= 0 || n > n2 ? 0 : n;
        this.loopEnd = n2 <= this.getMillisecondLength() && n2 > n ? (int)AudioUtils.millis2BytesFrameAligned(n2, this.format) : (int)AudioUtils.millis2BytesFrameAligned(this.getMillisecondLength(), this.format);
    }

    @Override
    public int getMillisecondPosition() {
        return (int)AudioUtils.bytes2Millis(this.totalBytesRead, this.format);
    }

    @Override
    public synchronized void setMillisecondPosition(int n) {
        this.totalBytesRead = n <= 0 ? 0 : (n > this.getMillisecondLength() ? this.samples.length : (int)AudioUtils.millis2BytesFrameAligned(n, this.format));
    }

    @Override
    public Control[] getControls() {
        return this.line.getControls();
    }

    @Override
    public AudioMetaData getMetaData() {
        return this.meta;
    }

    @Override
    public int getMillisecondLength() {
        return this.meta.length();
    }

    public int bufferSize() {
        return 0;
    }

    @Override
    public float[] read() {
        return null;
    }

    @Override
    public void read(MultiChannelBuffer multiChannelBuffer) {
    }
}

